#ifndef TYPEDEF_H_INCLUDED
#define TYPEDEF_H_INCLUDED

#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_ttf.h>
#include <SDL/SDL_mixer.h>

//On veut pouvoir utiliser chdir quelque soit le systme d'exploitation
#if defined WIN32 || defined WIN64 //Windows 32 ou 64 bits
  #include <dir.h>
  #define CMD_LINE "start \"\" \"Kaaptur.exe\""
#else //Le reste du monde... On considre qu'inclure la librairie standard unix suffit
  #include <unistd.h>
  #define CMD_LINE "\"./Kaaptur.exe\" &"
#endif

#define RESSOURCES_DIR "ressources/"
#define SOUNDS_DIR "sounds/"

// Enumration des types de terrain
enum tile_type {
SOL,        // Type Sol -> Franchissable
OBSTACLE,   // Type Obstacle -> Ne peut pas tre travers
CAMP,       // Type Obstacle -> Ne peut pas tre travers
MORTEL      // Type Mortel -> Tue le personnage qui s'y trouve
};

// Enumration des tats des cases
enum case_etat {
INCONNU,    // Non explor
MASQUE,     // Masqu par le brouillard de guerre
VISIBLE     // Compltement visible
};

// Enumeration des Types d'lements de GUI
enum gui_type {
IMAGE,  // Simple image
TEXTE,  // Simple texte
BOUTON, // Bouton avec uen action lors d'un clic
SWITCH, // Bouton ON/OFF
SAISIE, // Entre utilisateur
MAP     // Minimap, Avec deplacement de l'ecran
};

// Action des venements du GUI
enum gui_flag {
AUCUN,              // Ne dclenche rien (mais peut modifier une donne de manire transparente)
ECRAN,              // Ne dclenche rien (mais peut modifier une donne de manire transparente)
MINIMAP,            // Image de la minimap
MINIMAP_CURSEUR,    // Curseur de la minimap
FINIR,
JOUEUR_APERCU,
JOUEUR_NOM,
PIONACTUEL_APERCU,
PIONACTUEL_NOM,
PIONACTUEL_PTS,
PIONACTUEL_MVT,
FOND_PTS,
SAUVEGARDE_NOM,
SAUVEGARDER,
MESSAGES,           // Fenetre du chat
SWITCH_CMD,
CMD,                // Ligne de commande / saisie pour le chat
FPS,                 // Frames par secondes
POINTEUR
};

enum gui_groupe {
FENETRE,    // Pas de groupe particulier
BARRE,      // Barre Latrale
POPUP_CHAT, // Fenetre du Chat / Messages
};

// Etat des elements
enum gui_etat {
INACTIF,    // Element inactif
SURVOL,     // Element survol (Highlihted)
ACTIF       // Element actif (cliqu, actionn,...)
};

// Flag d'indication de la manire de librer les donnes d'un element
enum gui_free {
FREE_RIEN=0,    // Ne rien liberer (car pointeurs obselete)
FREE_IMAGE=1,   // Librer la surface de l'image
FREE_VALEUR=2   // Librer la chaine de caractre de la valeur
};

enum anim_type{
TELEPORTATION,
DEPLACEMENT,
MORT,
COMBAT
};

typedef enum enum_type_pion //Rang d'un pion
{
    GRAAL,
    ECLAIREUR,
    PECORE,
    CHEVALIER
}type_pion;

enum pion_angle{
S=0,
SO=1,
O=2,
NO=3,
N=4,
NE=5,
E=6,
SE=7
};

// Structure d'un lement du GUI - Graphical User Interface
typedef struct s_gui_element {
    /// Apparence de l'element
    enum gui_type   type; // Type de l'element (BOUTON, IMAGE, SWITCH, etc...)
    SDL_Surface     *image; // Surface de l'image de l'element
    char            *valeur; // Texte ou Valeur de l'element
    SDL_Rect        position; // Position de l'element
    SDL_Rect        crop; // Coordonnes de rognage
    enum gui_etat   etat; //0 -> Inactif, 1-> MOUSE_OVER, 2 - ACTIF
    long            visible; // Boolen qui indique sa visibilit

    ///Fonction de l'element
    enum gui_flag   flag; // Action de l'element
    enum gui_groupe groupe; // Groupe d'elements auquel appartient l'element
    /// Traitement de l'element
    enum gui_free   free; // Determine comment l'element doit tre supprim
//  long actualiser; // Determine si l'element a t modifi, et s'il doit tre re-blitt
} t_gui_element;

typedef struct s_options {
    char *pseudo;
    long volume_musique;
    long volume_son;
    long distance_inconnu;
    long distance_visible;
    long plein_ecran;
    long moonwalk;
    long poulette;
} t_options;

// Structure Unique de l'interface
typedef struct s_interface {
    /// Donnes d'affichage SDL
    SDL_Surface*    fenetre; // Surface contenant la fenetre
    TTF_Font*       font; // Police de Caractre de l'SDL_Rect ecran_prop; interface
    Mix_Music *musique; // Contient la musique du jeu (ou plutot l'ambiance sonore)

    /// Donnes du GUI
    long            gui_taille; // Nombre d'elements du GUI
    t_gui_element** gui; // Liste des elements du GUI
    t_gui_element*  gui_actif; // Pointeur sur l'element du GUI Actif/Courant

    /// Donnes de la saisie utilisatuer
    long            continuer; // Indique si la boucle principale doit tre poursuivie
    SDL_Rect        pointeur;// Position de la souris
    SDL_Rect        curseur;// Position du curseur dans la map
    long            clic; // Boolen de l'tat du clic (gauche)
    SDLKey          touche; // La touche actuellement enfonce
    char            touche_uni;
    long            mousefocus; // Boolen qui indique si la souris est dans la fenetre
    long            appfocus;// Utilis pour le clic, et le dessin de la map, et le focus de la fenetre

    /// Donnes du client
    t_options       options; // Contient toutes les options du jeu
    char            accent; //Retient si un accent (circonflxe, trma ou tilde) est entr
    long            pion;// Contient le numero du personnage actif
} t_interface;


// Structure d'une tile
typedef struct s_tile{
    enum tile_type type;    // Type de terrain
    long frame;             // Frame de l'animation en cours
    long cout_pts;          // Cot en Points de mouvement
    SDL_Color couleur;      // Couleur de la tile dans la minimap
} t_tile;

// Structure d'une case de la map
typedef struct s_map_case {
    long tile;              // Numro de la tile
    enum case_etat etat;    // Etat de la Case
} t_map_case;

// Structure d'un Tileset
typedef struct s_tileset {
    char* fichier;      // Nom du fichier du tileset
    long i, paquets;    // Nombre de paquets reus et  recevoir
    SDL_Surface* image; // Surface du tileset
    long largeur;       // Nombre de tile en largeur
    long hauteur;       // Nombre de tile en hauteur
} t_tileset;

// Structure de la Map
typedef struct s_map {
    /// Donnes de la map
    char* fichier;      // Nom du fichier de la map
    long i, paquets;    // Nombre de paquets reus et  recevoir
    long largeur;       // Largeur de la map
    long hauteur;       // Hauteur de la map
    t_map_case** cases; // Tableau 2D des cases de la map
    /// Apparence de la map
    t_tileset tileset;  // Tileset du dcor de la map
    t_tile* tile;       // Liste des tiles de la map
    t_tileset fx;       // Tileset des effets
} t_map;

typedef struct s_anim_liste //Dcrit un pion
{
    enum anim_type type;
    long x; // Contient la donne de position x
    long y; // Contient la donne de position y
    long valeur; // Contient une donne annexe
    long frame; // Frame courante de l'animation - 32 = FIN
    struct s_anim_liste *suivant;
}t_anim_liste;

typedef struct s_pion //Dcrit un pion
{
    long joueur; //Joueur qui possde le pion
    type_pion type; //Son type
    enum pion_angle angle;
    long pos_x, pos_y; //Sa position sur la map
    long pts, pts_max; //Ses points de dplacement restants et maximum
    long graal; //Vaut le numro du joueur dont l'unit porte le graal (0 sinon)
    t_anim_liste *anim; // Continent une liste chaine d'animations  effectuer.
}t_pion;

typedef struct s_joueur
{
    char *pseudo;
    long camp_x;
    long camp_y;
    t_tileset *tileset;
    SDL_Surface *avatar;
    SDL_Color couleur;
} t_joueur;

typedef struct s_partie //Dcrit une partie complte
{
    long joueur; // Numro du joueur
    long nbr_joueurs;// Nombre de joueur dans la partie
    long tour; //Joueur dont c'est le tour

    t_joueur *joueurs; // Contient tous les joueurs

    long nbr_pions; //Nombre de pions au total
    t_pion *pions; //Contient tous les pions de la partie

    Mix_Chunk ***sons;

    t_map map; // Contient la map
    long charge; //Vaut vrai lorsque le client est prt  jouer
}t_partie;


#endif // TYPEDEF_H_INCLUDED
